/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.actions.soap.request;

import junit.framework.TestCase;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.testutils.AbstractTestRunner;
import org.jboss.soa.esb.testutils.jbr.JBRServer;
import org.jboss.soa.esb.testutils.jbr.StaticRequestResponseHandler;

import java.util.HashMap;
import java.util.Map;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class SOAPClient_Request_UnitTest extends TestCase {

    public void test_request_no_wsdl_endpoint_override() throws Exception {
        // soapclient-request-config-01.xml doesn't define an "endpointURL" which would override the wsdl wsEndpoint
        // being invoked by the SOAPClient...
        test_request("soapclient-request-config-01.xml", "http://localhost:14999/", "http://localhost:15000");
    }

    public void test_request_wsdl_endpoint_override() throws Exception {
        // soapclient-request-config-02.xml defines an "endpointURL" which overrides the wsdl wsEndpoint
        // being invoked by the SOAPClient ("http://localhost:15111/")...
        test_request("soapclient-request-config-02.xml", "http://localhost:15111/", "http://localhost:15112");
    }

    private void test_request(String esbConfig, String wsEndpoint, final String wsdlEndpoint) throws Exception {
        JBRServer wsdlServer = new JBRServer(wsdlEndpoint, new StaticRequestResponseHandler(getClass().getResourceAsStream("request-test-01.wsdl")));
        StaticRequestResponseHandler wsEndpointHandler = new StaticRequestResponseHandler("<response/>");
        JBRServer wsEndpointServer = new JBRServer(wsEndpoint, wsEndpointHandler);

        // Check the SOAP request coming into the Server...
        wsEndpointHandler.setExpectedRequest(getClass().getResourceAsStream("expected-soap-request.xml"));

        wsdlServer.start();
        try {
            wsEndpointServer.start();
            try {
                new AbstractTestRunner() {
                    public void test() throws Exception {
                        ServiceInvoker invoker = new ServiceInvoker("OrderManagement", "GoodbyeService");
                        Message message = MessageFactory.getInstance().getMessage();
                        Map params = new HashMap();

                        params.put("sayGoodbye.message", "Goodbye Henry!!");
                        message.getBody().add(params);

                        message = invoker.deliverSync(message, 10000);

                        String soapResponse = (String) message.getBody().get();
                        assertEquals("<response/>", soapResponse);
                    }
                }.setServiceConfig(esbConfig).run();
            } finally {
                wsEndpointServer.stop();
            }
        } finally {
            wsdlServer.stop();
        }
    }
}
