package org.jboss.soa.esb.actions.soap;

import java.io.IOException;
import java.util.Map;

import junit.framework.TestCase;

import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.actions.soap.SOAPClient.Response;
import org.jboss.soa.esb.actions.soap.beans.Order;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.testutils.ESBConfigUtil;
import org.xml.sax.SAXException;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class SOAPClient_Response_UnitTest extends TestCase {

    private ESBConfigUtil configUtil;

    public SOAPClient_Response_UnitTest() throws IOException, SAXException, ConfigurationException {
        configUtil = new ESBConfigUtil(getClass().getResourceAsStream("soapclient-config-01.xml"));
    }

    public void test_XStream_ResponseProcessing() throws ConfigurationException, ActionProcessingException {
        ConfigTree actionConfig = configUtil.getActionConfig("OrderNotificationService", "soapui-client-action-01");
        SOAPClient soapClient = new SOAPClient(actionConfig);
        Message message = MessageFactory.getInstance().getMessage();

        soapClient.processResponse(message, response_01);
        assertEquals(true, message.getBody().get());

        soapClient.processResponse(message, response_02);
        assertEquals(false, message.getBody().get());
    }

    @SuppressWarnings("unchecked")
    public void test_OgnlMap_ResponseProcessing_1() throws ConfigurationException, ActionProcessingException {
        ConfigTree actionConfig = configUtil.getActionConfig("OrderNotificationService", "soapui-client-action-02");
        SOAPClient soapClient = new SOAPClient(actionConfig);
        Message message = MessageFactory.getInstance().getMessage();

        soapClient.processResponse(message, response_01);
        Map<String, String> response = (Map<String, String>) message.getBody().get();
        assertEquals("true", response.get("customerOrderAck"));

        soapClient.processResponse(message, response_02);
        response = (Map<String, String>) message.getBody().get();
        assertEquals("false", response.get("customerOrderAck"));
    }

    public void test_OgnlMap_ResponseProcessing_2() throws ConfigurationException, ActionProcessingException {
        ConfigTree actionConfig = configUtil.getActionConfig("OrderNotificationService", "soapui-client-action-05");
        SOAPClient soapClient = new SOAPClient(actionConfig);
        String responseString = new String(StreamUtils.readStream(getClass().getResourceAsStream("soap-message-01.xml")));
        Message message = MessageFactory.getInstance().getMessage();

        soapClient.processResponse(message, new Response(responseString));
        @SuppressWarnings("unused")
		Order order = (Order) message.getBody().get();
        //assertEquals();
    }

    @SuppressWarnings("unchecked")
    public void test_OgnlMap_ResponseProcessing_3() throws ConfigurationException, ActionProcessingException {
        ConfigTree actionConfig = configUtil.getActionConfig("OrderNotificationService", "soapui-client-action-02");
        SOAPClient soapClient = new SOAPClient(actionConfig);
        String responseString = new String(StreamUtils.readStream(getClass().getResourceAsStream("soap-message-01.xml")));
        Message message = MessageFactory.getInstance().getMessage();

        soapClient.processResponse(message, new Response(responseString));
        Map<String, String> responseMap = (Map<String, String>) message.getBody().get();

        assertEquals("{customerOrder.orderheader.customerName=Tom Fennelly, customerOrder.items[0].partNumber=1, customerOrder.items[0].description=desc-1, customerOrder.items[0].quantity=1, customerOrder.items[0].price=1.1, customerOrder.items[0].extensionAmount=1, customerOrder.items[1].partNumber=2, customerOrder.items[1].description=desc-2, customerOrder.items[1].quantity=2, customerOrder.items[1].price=2.2, customerOrder.items[1].extensionAmount=2}", responseMap.toString());
    }

    public void test_No_ResponseProcessing() throws ConfigurationException, ActionProcessingException {
        ConfigTree actionConfig = configUtil.getActionConfig("OrderNotificationService", "soapui-client-action-03");
        SOAPClient soapClient = new SOAPClient(actionConfig);
        Message message = MessageFactory.getInstance().getMessage();

        soapClient.processResponse(message, response_01);
        assertEquals(response_01.getBody(), message.getBody().get());
    }

    public void test_ResponseLocation() throws ConfigurationException, ActionProcessingException {
        ConfigTree actionConfig = configUtil.getActionConfig("OrderNotificationService", "soapui-client-action-04");
        SOAPClient soapClient = new SOAPClient(actionConfig);
        Message message = MessageFactory.getInstance().getMessage();

        soapClient.processResponse(message, response_01);
        assertEquals(response_01.getBody(), message.getBody().get("myTestLocation"));
    }

    public void test_getEndpointOperation() throws ConfigurationException, ActionProcessingException {
        ConfigTree actionConfig = configUtil.getActionConfig("OrderNotificationService", "soapui-client-action-07");
        SOAPClient soapClient = new SOAPClient(actionConfig);
        assertEquals("SendSalesOrderNotification", soapClient.getEndpointOperation());
    }
    
    public void test_soapSetSOAPNameSpace() throws ConfigurationException, ActionProcessingException {
    	String expectedSOAPNS = "http://www.w3.org/2003/05/soap-envelope";
        ConfigTree actionConfig = configUtil.getActionConfig("OrderNotificationService", "soapui-client-action-07");
        actionConfig.setAttribute( "SOAPNS", expectedSOAPNS );
        SOAPClient soapClient = new SOAPClient(actionConfig);
        assertEquals( expectedSOAPNS, soapClient.getSoapNS());
    }


    private static Response response_01 = new Response(
            "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n" +
            "\t<soapenv:Header/>\n" +
            "\t<soapenv:Body>\n" +
            "\t\t<aetgt:customerOrderAck xmlns:aetgt=\"http://schemas.active-endpoints.com/sample/customerorder/2006/04/CustomerOrder.xsd\">true</aetgt:customerOrderAck>\n" +
            "\t</soapenv:Body>\n" +
            "</soapenv:Envelope>");
    private static Response response_02 = new Response(
            "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n" +
            "\t<soapenv:Body>\n" +
            "\t\t<aetgt:customerOrderAck xmlns:aetgt=\"http://schemas.active-endpoints.com/sample/customerorder/2006/04/CustomerOrder.xsd\">false</aetgt:customerOrderAck>\n" +
            "\t</soapenv:Body>\n" +
            "</soapenv:Envelope>");
}
