/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.smooks.splitting;

import org.jboss.soa.esb.Configurable;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.smooks.resource.SmooksResource;
import org.milyn.Smooks;
import org.milyn.event.report.HtmlReportGenerator;
import org.milyn.container.ExecutionContext;

import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * Abstract stream splitter.
 * <p/>
 * Uses Smooks to perform the message splitting.
 *
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public abstract class AbstractStreamSplitter implements Configurable {

    private Smooks smooks;
    private String encoding;
    private String reportPath;

    public void setConfiguration(ConfigTree config) throws ConfigurationException {
        String splitterConfig = config.getRequiredAttribute("splitterConfig");

        encoding = config.getAttribute("encoding", "UTF-8");
        reportPath = config.getAttribute("reportPath");
        try {
            smooks = SmooksResource.createSmooksResource(splitterConfig);
        } catch (Exception e) {
            throw new ConfigurationException("Failed to create smooks resource", e) ;
        }
    }

    public void split(InputStream dataStream) throws IOException {
        Source streamSource = new StreamSource(new InputStreamReader(dataStream, encoding));

        if(reportPath != null) {
            ExecutionContext execContext = smooks.createExecutionContext();

            execContext.setEventListener(new HtmlReportGenerator(reportPath));
            smooks.filter(streamSource, null, execContext);
        } else {
            smooks.filter(streamSource, null);            
        }
    }
}