/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.services.rules.util;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import junit.framework.JUnit4TestAdapter;

import org.jboss.internal.soa.esb.services.rules.RuleServiceException;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.routing.MessageRouterException;
import org.junit.Test;

/**
 * Unit test for {@link RuleConfigUtil}.
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 *
 */
public class RuleConfigUtilUnitTest
{
    @Test
    public void extractObjectsFromMessage() throws ConfigurationException, RegistryException, MessageRouterException, RuleServiceException
    {
        final Message message = MessageFactory.getInstance().getMessage();
        message.getBody().add("TestString", "bajja");
        
        final Map<String, List<String>> entryPointMap = new HashMap<String, List<String>>();
        final ArrayList<String> objectNames = new ArrayList<String>();
        objectNames.add("body.TestString");
        entryPointMap.put("entryPoint1", objectNames);
        
        final Map<String, List<Object>> entryPoints = RuleConfigUtil.extractObjectsFromMessage(entryPointMap, message);
        
        assertNotNull(entryPoints);
        assertEquals(1, entryPoints.size());
        assertTrue(entryPoints.containsKey("entryPoint1"));
        final List<Object> objects = entryPoints.get("entryPoint1");
        System.out.println(objects);
        assertTrue(objects.contains("bajja"));
    }
    
    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(RuleConfigUtilUnitTest.class);
    }

}
