/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.services.rules;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Properties;

import junit.framework.JUnit4TestAdapter;

import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.agent.AgentEventListener;
import org.drools.agent.RuleAgent;
import org.drools.common.DroolsObjectOutputStream;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.rule.Package;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.ConfigurationException;
import org.junit.Ignore;
import org.junit.Test;

/**
 * Unit test for {@link DroolsRuleBaseHelper}
 * <p/>
 * 
 * @author <a href="mailto:dbevenius@redhat.com">Daniel Bevenius</a>
 *
 */
public class DroolsRuleBaseHelperUnitTest
{
	// instance under test
	private DroolsRuleBaseHelper helper = DroolsRuleBaseHelper.getInstance();
	
	private final static String NULL_DSL_FILE = null;
	private final static String NULL_RULE_FILE = null;
	private final static String NULL_DECISION_TABLE_FILE = null;
	
	@Test ( expected = NullPointerException.class )
	public void shouldThrowIfRuleFileIsNull() throws DroolsParserException, IOException, RuleServiceException
	{
		helper.createRuleBaseFromRuleFiles( NULL_RULE_FILE, NULL_DSL_FILE );
	}
	
	@Test
	public void createRuleBaseFromRuleFiles() throws DroolsParserException, IOException, RuleServiceException
	{
		RuleBase ruleBase = helper.createRuleBaseFromRuleFiles( "RuleBaseHelper.drl", NULL_DSL_FILE );
		
		assertNotNull( ruleBase );
		assertTrue( ruleBase.getPackages().length > 0 );
		assertEquals( "org.jboss.internal.soa.esb.rules" , ruleBase.getPackages()[0].getName());
	}
	
	@Test ( expected = NullPointerException.class )
	public void shouldThrowIfDecisionTableIsNull() throws DroolsParserException, IOException, RuleServiceException
	{
		helper.createRuleBaseFromDecisionTable( NULL_DECISION_TABLE_FILE );
	}
	
	@Test
	public void createRuleBaseFromDecisionTable() throws DroolsParserException, IOException, RuleServiceException
	{
		RuleBase ruleBase = helper.createRuleBaseFromDecisionTable( "RuleBaseHelper.xls" );
		assertNotNull( ruleBase );
		assertEquals( "org.jboss.internal.soa.esb.rules", ruleBase.getPackages()[0].getName());
	}
	
	@Test ( expected = NullPointerException.class )
	public void getRuleAsStringShouldThrowIfRuleFileIsNull() throws IOException, RuleServiceException
	{
		String rulesAsString = helper.getRulesAsString( NULL_RULE_FILE, NULL_DSL_FILE );
		assertNotNull( rulesAsString );
	}
	
	@Test
	public void getRuleFileAsString() throws IOException, RuleServiceException
	{
		String rulesAsString = helper.getRulesAsString( "RuleBaseHelper.drl", NULL_DSL_FILE );
		assertNotNull( rulesAsString );
	}
	
	@Test
	public void getSpreadSheetRules() throws IOException, RuleServiceException
	{
		String spreadSheetAsString = helper.getSpreadsheetRules( "RuleBaseHelper.xls" );
		assertNotNull( spreadSheetAsString );
	}
	
	@Test
	public void verifyRuleAgentPkgFile() throws DroolsParserException, RuleServiceBuilderException, IOException, RuleServiceException
	{
	    final Properties properties = new Properties();
	    URL pkgUrl = getClass().getResource("/testrules.pkg");
	    
	    properties.setProperty("newInstance", "true");
	    properties.setProperty("file", pkgUrl.getFile());
	    properties.setProperty("poll", "20");
	    properties.setProperty("name", "MyConfig");
	    
	    // note that the is an exception occurs TestAgentEventListeners exception 
	    // method will be called an this test will fail.
	    RuleAgent ruleAgent = RuleAgent.newRuleAgent(properties, new LogAgentEventListener());
	    Package pkg = ruleAgent.getRuleBase().getPackage("org.jboss.internal.soa.esb.rules");
	    assertNotNull(pkg);
	    assertEquals("org.jboss.internal.soa.esb.rules", pkg.getName());
	}
	
	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter( DroolsRuleBaseHelperUnitTest.class );
	}
	
}
