/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.rules;

/**
 * RuleInfoImpl contains stateful related rule execution configuration parameters that
 * are passed to the {@link RuleService}.
 *
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 * @since 4.6
 *
 */
public interface StatefulRuleInfo extends RuleInfo
{
    /**
     * If continueState is false the stateful working memory should be disposed of prior to processing.
     * Not disposing a working memory you lead to memory leaks.
     *
     * @return {@code boolean} If the working memory should be disposed of (cleaned up) prior to processing.
     */
    boolean continueState();
    /**
     * If dispose is true the stateful working memory should be disposed of after processing.
     * Not disposing a working memory you lead to memory leaks.
     *
     * @return {@code boolean} If the working memory should be disposed of (cleaned up) after processing.
     */
    boolean dispose();
}
