/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.services.rules;

import org.apache.log4j.Logger;
import org.drools.agent.AgentEventListener;

/**
 * Drools AgentEventListener that delegates to log4j.
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public class LogAgentEventListener implements AgentEventListener
{
    private Logger log = Logger.getLogger(LogAgentEventListener.class);
    
    private String agentName;

    public void setAgentName(final String name)
    {
        agentName = name;
    }

    public void debug(final String message)
    {
        log.debug(getAgentName() + " " + message);
    }

    public void debug(final String message, final Object object)
    {
        log.debug(getAgentName() + " Message : " + message + ", object = " + object);
    }

    public void exception(final Exception e)
    {
        log.error(getAgentName() + " " + e.getMessage(), e);
    }

    public void info(final String message)
    {
        log.info(getAgentName() + " " + message);
    }

    public void info(final String message, final Object object)
    {
        log.info(getAgentName() + " Message : " + message + ", object = " + object);
    }

    public void warning(final String message)
    {
        log.warn(getAgentName() + " " + message);
    }

    public void warning(final String message, final Object object)
    {
        log.warn(getAgentName() + " Message : " + message + ", object = " + object);
    }
    
    private String getAgentName()
    {
        return "AgentName = '" + agentName + "'";
    }
    
    public void exception(Throwable e)
    {
        log.error(getAgentName() + " Exception: " + e.getMessage(), e);
    }

    public void exception(String message, Throwable t)
    {
        log.error(getAgentName() + " Exception :" + message, t);
    }
}
