/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.services.jbpm.actionhandlers;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.net.URI;

import junit.framework.JUnit4TestAdapter;

import org.jboss.internal.soa.esb.couriers.MockCourier;
import org.jboss.internal.soa.esb.couriers.MockCourierFactory;
import org.jboss.internal.soa.esb.services.registry.MockRegistry;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.services.jbpm.Constants;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.junit.BeforeClass;
import org.junit.Test;

public class EsbActionHandlerUnitTest
{
    private static EPR epr1;
    private static MockCourier courier1;
    private static String MOCK_CATEGORY="MockCategory";
    private static String MOCK_SERVICE ="MockService";
    
    @BeforeClass
    public static void setup() throws Exception
    {
        MockCourierFactory.install();
        MockRegistry.install();
        epr1 = new EPR(new URI("test1"));
        courier1 = new MockCourier(true);
        MockRegistry.register(MOCK_CATEGORY, MOCK_SERVICE, epr1, courier1);
    }
    
    @Test
	public void testSimpleProcess() throws Exception 
	{
		// Extract a process definition from the processdefinition.xml file.
		ProcessDefinition processDefinition  = ProcessDefinition.parseXmlResource("testMappingDefinition.xml");
		
		assertNotNull(processDefinition);

		// Create an instance of the process definition.
		ProcessInstance instance = new ProcessInstance(processDefinition);
		assertEquals("start", instance.getRootToken().getNode().getName());

		String varVal = "HELLO world";
		String second = "Second Hello";
		String body	 = "This text in Message body"; 
			
		Token token = instance.getRootToken();
		instance.getContextInstance().createVariable("v1", varVal, token);
		instance.getContextInstance().createVariable("g2", second);
		instance.getContextInstance().createVariable("body", body.getBytes(),token);
        
        //Signal the token and the Mock Service will be called.
		instance.signal();
        
        //the node is now in a wait state in the "first" state
        assertEquals("first", instance.getRootToken().getNode().getName());

		instance.signal();
		assertEquals("end", instance.getRootToken().getNode().getName());
		assertTrue(instance.hasEnded());
	}
    
    /**
     * Test for Jira: 
     * https://jira.jboss.org/jira/browse/JBESB-2228 "Replies/faults generated from within jBPM should initialise the relatesTo"
     */
    @Test
    public void wasRelatesToSetAfterJbpmFault() throws Exception 
    {
        ProcessDefinition processDefinition  = ProcessDefinition.parseXmlResource("relatesToFaultDefinition.xml");
        ProcessInstance instance = new ProcessInstance(processDefinition);
        
        /*
         * Simulate the setting of ESB MessageId that is performed by NewProcessInstancePerformer
         * This is only set if either faultTo or ReplyTo has also been stored.
         */
        URI orgEsbMessageId = new URI("someuri");
		instance.getContextInstance().setVariable(Constants.ESB_MESSAGE_ID, orgEsbMessageId);
		instance.getContextInstance().setVariable(Constants.REPLY_TO, new URI("faultto"));
		
        instance.signal();
        instance.signal();
		assertEquals("exception", instance.getRootToken().getNode().getName());
        instance.signal();
		assertEquals("end", instance.getRootToken().getNode().getName());
        
        final URI relatesTo = courier1.message.getHeader().getCall().getRelatesTo();
        assertEquals(orgEsbMessageId, relatesTo);
    }
    
    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(EsbActionHandlerUnitTest.class);
    }

}
