/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.jbpm.integration.msg;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;

import org.jboss.soa.esb.services.jbpm.integration.AbstractJmsJobService;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.job.Job;
import org.jbpm.msg.MessageService;

public class JmsMessageService extends AbstractJmsJobService implements MessageService {
    /**
     * Serial Version UID for this class.
     */
    private static final long serialVersionUID = 9165420651941799915L;

    /**
     * Construct the JMS message service.
     * @param connectionFactory The associated JMS connection factory.
     * @param destination The JMS destination.
     * @param isCommitEnabled true if commit is to be invoked, false otherwise.
     * @throws JMSException For JMS errors.
     */
    public JmsMessageService(ConnectionFactory connectionFactory, Destination destination, boolean isCommitEnabled) throws JMSException {
        super(getJbpmContext(), connectionFactory, destination, isCommitEnabled) ;
    }
    
    /**
     * Obtain the current jBPM context.
     * @return The jBPM context.
     * @throws JbpmException if there is no active jBPM context.
     */
    private static JbpmContext getJbpmContext()
    {
        final JbpmContext jbpmContext = JbpmConfiguration.getInstance().getCurrentJbpmContext();
        if (jbpmContext==null) {
            throw new JbpmException("jms message service must be created inside a jbpm context");
        }
        return jbpmContext ;
    }

    /**
     * Send the job to the job executor.
     * @param job The job to send.
     */
    public void send(Job job) {
        sendJob(job) ;
    }
}
