/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * (C) 2005-2008, JBoss Inc.
 */
package org.jboss.soa.esb.services.jbpm.cmd;

import org.jbpm.command.VariablesCommand;
import org.jbpm.JbpmContext;
import org.jbpm.context.exe.VariableContainer;

/**
 * Get the process variables {@link java.util.Map}.
 * <p/>
 * This version of {@link VariablesCommand} "hungrily" gets the process
 * variable, while still inside the jBPM execution context.
 * <p/>
 * {@link VariablesCommand} just returns a lazy proxy that gets the variables lazily.
 * Gets from this proxy fail outside the context of a jBPM execution context. 
 *
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class HungryVariablesCommand extends VariablesCommand {

    public Object execute(JbpmContext jbpmContext) throws Exception {
        VariableContainer variableContainer = getVariableContainer(jbpmContext);
        return variableContainer.getVariables();
    }
}
