/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.util;

import static org.junit.Assert.*;
import junit.framework.JUnit4TestAdapter;

import org.junit.Test;

/**
 * Unit test for {@link XssUtil}.
 * <p/>
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public class XssUtilUnitTest
{
    private String expectedUrl = "http://www.jboss.org/jbossesb/attribute.jsp?&lt;script&gt;alert('sometext')&lt;/script&gt;";
    private String expectedUrlNonClosingTags = "http://www.jboss.org/jbossesb/attribute.jsp?&lt;script&gt;alert('sometext')&lt;script&gt;";
    
    @Test
    public void escapeNoSpecialCharacters()
    {
        String url = "http://wwww.jboss.org/jbossesb/attribute.jsp";
        String escaped = XssUtil.escape(url);
        assertEquals(url, escaped);
    }
    
    @Test
    public void escapeScriptTag()
    {
        String escaped = XssUtil.escape("http://www.jboss.org/jbossesb/attribute.jsp?<script>alert('sometext')</script>");
        assertEquals(expectedUrl, escaped);
    }
    
    @Test 
    public void escapeScriptTagsWithOutClosingTag()
    {
        String escaped = XssUtil.escape("http://www.jboss.org/jbossesb/attribute.jsp?<script>alert('sometext')<script>");
        assertEquals(expectedUrlNonClosingTags, escaped);
    }
    
    @Test 
    public void escapeUnicodeScriptTags()
    {
        String escaped = XssUtil.escape("http://www.jboss.org/jbossesb/attribute.jsp?%3Cscript%3Ealert('sometext')%3C/script%3E");
        assertEquals(expectedUrl, escaped);
    }
    
    @Test 
    public void escapeUnicodeScriptTagsWithOutClosingTag()
    {
        String escaped = XssUtil.escape("http://www.jboss.org/jbossesb/attribute.jsp?%3Cscript%3Ealert('sometext')%3Cscript%3E");
        assertEquals(expectedUrlNonClosingTags, escaped);
    }
    
    @Test 
    public void escapeQuote()
    {
        String escaped = XssUtil.escape("\"sometext\"");
        assertEquals("&quot;sometext&quot;", escaped);
        
    }
    
    @Test 
    public void escapeBodyOnloadTag()
    {
        String escaped = XssUtil.escape("http://127.0.0.1:8080/jbossesb/attribute.jsp?servername=%22%3CBODY%20ONLOAD=alert(%27XSS%27)%3E%22&id=80");
        assertEquals("http://127.0.0.1:8080/jbossesb/attribute.jsp?servername=%22&lt;BODY%20ONLOAD=alert(%27XSS%27)&gt;%22&amp;id=80", escaped);
    }
    
    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(XssUtilUnitTest.class);
    }

}
