/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.util;

import java.io.ByteArrayInputStream;

import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import junit.framework.JUnit4TestAdapter;

import org.apache.commons.io.output.ByteArrayOutputStream;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xml.sax.InputSource;

/**
 * Test for processing bindings-jboss-beans.xml for AS 5.1.0.GA.
 * <p/>
 * Note: that the files used in this test are located in this classes package, 
 * and they are not the ones that are actually used upon deployment.
 * The idea is that for a new version a of AS we can add more test 
 * methods for them before we include them in our build.
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 * @since 4.7
 */
public class BindingsTransformUnitTest
{
    private static TransformerFactory transformerFactory;

    @BeforeClass
    public static void setup()
    {
        transformerFactory = TransformerFactory.newInstance();
    }
    
    /**
     * Tests JBoss AS 5.1.0.GA ServiceBindingManager configuration
     */
    @Test
    public void transform_AS_5_1_0_GA() throws Exception
    {
        final Source bindingsXml = new StreamSource(getClass().getResourceAsStream("bindings-jboss-beans-as-5-1-0-GA.xml"));
        final Source bindinsXslt = new StreamSource(getClass().getResourceAsStream("bindings-jboss-beans-as-5-1-0-GA.xslt"));
        final InputSource bindingsValid = new InputSource(getClass().getResourceAsStream("valid-bindings-jboss-beans-as-5-1-0-GA.xml"));

        final StreamResult streamResult = new StreamResult(new ByteArrayOutputStream());
        
        transformerFactory.newTransformer(bindinsXslt).transform(bindingsXml, streamResult);
        
        final ByteArrayInputStream bin = new ByteArrayInputStream(((ByteArrayOutputStream)streamResult.getOutputStream()).toByteArray());
        final InputSource transformResult = new InputSource(bin);
        
        Assert.assertTrue("XML Comparison", XMLHelper.compareXMLContent(bindingsValid, transformResult));
    }
    
    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(BindingsTransformUnitTest.class);
    }

}
