package org.jboss.soa.esb.testutils.test;

import junit.framework.TestCase;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.testutils.ESBConfigUtil;
import org.xml.sax.SAXException;

import java.io.IOException;

/**
 * @author
 */
public class ESBConfigUtilUnitTest extends TestCase {

    public void test() throws ConfigurationException, IOException, SAXException {
        executeTest("jboss-esb.xml");
    }

    public void test110() throws ConfigurationException, IOException, SAXException {
        executeTest("jboss-esb.110.xml");
    }

    public void test120() throws ConfigurationException, IOException, SAXException {
        executeTest("jboss-esb.120.xml");
    }

    private void executeTest(final String config) throws ConfigurationException, IOException, SAXException {
        ESBConfigUtil configUtil = new ESBConfigUtil(getClass().getResourceAsStream(config));

        assertTrue(configUtil.getListenerConfig("JMS-ESBListener").toString().startsWith("<listener busIdRef=\"OrderManagerService\" listenerClass=\"org.jboss.soa.esb.listeners.message.MessageAwareListener\" maxThreads=\"1\" name=\"JMS-ESBListener\" service-category=\"ABI_OrderManager\" service-description=\"ABI OrderManager Service\" service-name=\"ABI_OrderManager\">"));
        assertTrue(configUtil.getGatewayConfig("FileGateway").toString().startsWith("<listener"));
        assertTrue(configUtil.getActionConfig("OrderNotificationService", "print-after-transform").toString().startsWith("<action action=\"print-after-transform\""));
    }
}
