/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.testutils.jbr;

import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.transport.Connector;

import java.util.Map;
import java.util.HashMap;

/**
 * JBoss Remoting Server utility for testing.
 * 
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class JBRServer {

    private String serverURI;
    private Connector connector;
    private boolean isStarted = false;

    public JBRServer(String serverURI, ServerInvocationHandler handler) throws Exception {
        this(serverURI, handler, new HashMap<String, String>());
    }

    public JBRServer(String serverURI, ServerInvocationHandler handler, Map<String, String> connectorConfig) throws Exception {
        InvokerLocator locator = new InvokerLocator(serverURI);

        this.serverURI = serverURI;
        connector = new Connector(locator, connectorConfig);
        connector.create();
        connector.addInvocationHandler(handler.getClass().getName(), handler);
    }

    public void start() throws Exception {
        if(isStarted) {
            throw new RuntimeException("Server '" + serverURI + "' already started.");
        }
        connector.start();
        isStarted = true;
    }

    public void stop() {
        if(!isStarted) {
            throw new RuntimeException("Server '" + serverURI + "' not started.");
        }
        connector.stop();
        isStarted = false;
    }
}
