/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security.auth.ws;

import static java.util.concurrent.TimeUnit.NANOSECONDS;
import static org.junit.Assert.assertEquals;

import java.io.InputStream;

import junit.framework.JUnit4TestAdapter;

import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.util.ClassUtil;
import org.junit.Ignore;
import org.junit.Test;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;
import org.w3c.dom.Element;

/**
 * Unit test for {@link SamlAssertionExtractor}.
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 * 
 */
public class SamlAssertionExtractorUnitTest
{
    /**
     * Intentionally ignored. Takes some time to run and is indended to be run maually.
     */
    @Test
    @Ignore
    public void performance() throws Exception
    {
        final SamlAssertionExtractor extractor = new SamlAssertionExtractor();
        final String soap = readFile("soap-saml-example.xml");
        @SuppressWarnings("unused")
        AuthenticationRequest authRequest = null;
        
        // warm up 
        for (int i = 0; i < 5000; i++)
        {
            authRequest = extractor.extractSecurityInfo(soap);
        }
        
        final int iterations = 1000000;
        final long start = System.nanoTime();
        for (int i = 0; i < iterations; i++)
        {
            authRequest = extractor.extractSecurityInfo(soap);
        }
        final long duration = System.nanoTime() - start;
        System.out.println(iterations + " took : " + NANOSECONDS.toSeconds(duration) + "s");
    }

    @Test
    public void extractAssertionFromSOAPString() throws Exception
    {
        final SamlAssertionExtractor extractor = new SamlAssertionExtractor();
        final String samlAssertion = extractor.extractSamlAssertion(readFile("soap-saml-example.xml"));
        Element assertionElement = SamlCredential.assertionToElement(samlAssertion);

        assertEquals("saml:Assertion", assertionElement.getNodeName());
    }
    
	private String readFile(final String fileName) throws Exception
    {
        InputStream inputStream = ClassUtil.getResourceAsStream(fileName, getClass());
        return new String(StreamUtils.readStream(inputStream));
    }

    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(SamlAssertionExtractorUnitTest.class);
    }

}
