/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security.auth.ws;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import java.io.InputStream;
import java.security.cert.Certificate;

import junit.framework.JUnit4TestAdapter;

import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.util.ClassUtil;
import org.junit.Test;

/**
 * Unittest for {@link BinarySecurityToken}
 *
 * @author <a href="mailto:dbevenius@redhat.com">Daniel Bevenius</a>
 *
 */
public class BinarySecurityTokenUnitTest
{
	private String expectedEncoding = "Base64Binary";
	private String expectedValueType = "X509v3";
	private BinarySecurityToken token = new BinarySecurityToken();

	@Test
	public void setEncodingTypeWithNSPrefix()
	{
		token.setEncodingType("wsse:" + expectedEncoding);
		assertEquals( expectedEncoding, token.getEncodingType() );
	}

	@Test
	public void setEncodingTypeWithNSPrefix2()
	{
		token.setEncodingType("d:" + expectedEncoding);
		assertEquals( expectedEncoding, token.getEncodingType() );
	}

	@Test
	public void setEncodingTypeWithoutNSPrefix()
	{
		token.setEncodingType(expectedEncoding);
		assertEquals( expectedEncoding, token.getEncodingType() );
	}

	@Test
	public void setEncodingTypeFullPath()
	{
		String url = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
		token.setEncodingType(url);
		assertEquals( expectedEncoding, token.getEncodingType() );
	}

	@Test
	public void setValueType()
	{
		String url = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
		token.setValueType(url);
		assertEquals( expectedValueType, token.getValueType() );
	}

	@Test
	public void setEncodingType()
	{
		token.setEncodingType(expectedEncoding);
		assertEquals( expectedEncoding, token.getEncodingType() );
	}

	@Test
	public void setEncodingTypeNull()
	{
		token.setEncodingType(null);
		assertNull(token.getEncodingType());
	}

	@Test
	public void setKey() throws Exception
	{
		token.setEncodingType(expectedEncoding);
		token.setValueType(expectedValueType);
		token.setKey(getExampleCert());
		Certificate key = token.getKey();
		assertNotNull(key);
	}

	private String getExampleCert() throws Exception
	{
		InputStream inputStream = ClassUtil.getResourceAsStream("cert-example.xml", getClass() );
		return new String(StreamUtils.readStream(inputStream));
	}

	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter(BinarySecurityTokenUnitTest.class);
	}

}
