package org.jboss.soa.esb.services.security;

import java.io.IOException;
import java.util.Map;

import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class UserPassLoginModule implements LoginModule
{
	private Subject subject;
	private CallbackHandler callbackHandler;
	private TestPrincipal principal;

	private String userName = null;
	private boolean succeeded = false;
	private boolean commitSucceeded = false;

	public void initialize(
			final Subject subject, 
			final CallbackHandler callbackHandler , 
			final Map<String,?> sharedMap, 
			final Map<String,?> options)
	{
		this.subject = subject;
		this.callbackHandler = callbackHandler;
	}

	public boolean login() throws LoginException
	{
		NameCallback nameCallback = new NameCallback("user:");
		PasswordCallback passwordCallback = new PasswordCallback("password:", true);
		try
		{
			callbackHandler.handle(new Callback[] { nameCallback, passwordCallback });
		} 
		catch (IOException e)
		{
			throw new LoginException(e.getMessage());
		} 
		catch (UnsupportedCallbackException e)
		{
			throw new LoginException(e.getMessage());
		}
		
		// dummy login
		final String name = nameCallback.getName();
		final String passwd = new String(passwordCallback.getPassword());
		if (name.equals("testUser") && passwd.equals("testPassword"))
		{
			userName = name;
			succeeded = true;
			return true;
		} else
		{
			succeeded = false;
			return false;
		}
	}

	public boolean commit() throws LoginException
	{
		if (!succeeded)
		{
			userName = null;
			return false;
		}

		principal = new TestPrincipal(userName);
		if (!subject.getPrincipals().contains(principal))
		{
			subject.getPrincipals().add(principal);
		}

		userName = null;
		commitSucceeded = true;
		return true;
	}

	public boolean abort() throws LoginException
	{
		if (succeeded == false)
		{
			return false;
		}
		else if (succeeded == true && commitSucceeded == true)
		{
			logout();
		} 
		else
		{
			succeeded = false;
		}
		return true;
	}

	public boolean logout() throws LoginException
	{
		subject.getPrincipals().remove(principal);
		principal = null;
		userName = null;
		succeeded = commitSucceeded = false;
		return true;
	}
}
