/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.schedule.JBESB_2146;

import org.jboss.soa.esb.listeners.ScheduledEventMessageComposer;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.schedule.SchedulingException;
import org.jboss.soa.esb.schedule.MockScheduledEventMessageComposer;

import java.util.*;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class JBESB_2146_ScheduledEventMessageComposer implements ScheduledEventMessageComposer {

    public ConfigTree config;
    public List<Message> composedMessages = Collections.synchronizedList(new ArrayList<Message>());
    public List<Message> completedMessage = Collections.synchronizedList(new ArrayList<Message>());
    private static Map<String, JBESB_2146_ScheduledEventMessageComposer> composers = new HashMap<String, JBESB_2146_ScheduledEventMessageComposer>();

    public void reset() {
        composedMessages.clear();
        completedMessage.clear();
    }

    public void initialize(ConfigTree config) {
        this.config = config;
        composers.put(config.getAttribute("name"), this);
    }

    public static JBESB_2146_ScheduledEventMessageComposer getComposer(String name) {
        return composers.get(name);
    }

    public void uninitialize() {
    }

    public Message composeMessage() throws SchedulingException {
        Message message = org.jboss.soa.esb.message.format.MessageFactory.getInstance().getMessage();
        composedMessages.add(message);
        return message;
    }

    public Message onProcessingComplete(Message message) throws SchedulingException {
        completedMessage.add(message);
        return message;
    }
}