/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.persistence.manager;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.common.Environment;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.common.tests.BaseTest;
import org.jboss.soa.esb.common.tests.MockDataSource;
import org.mockejb.jndi.MockContextFactory;

/**
 * Test of the ConnectionManagerFactory - test whether it throws exceptions
 * correctly and whether it can successfully instantiate a ConnectionManagerFactory
 * instance.
 * 
 * @author tcunning@redhat.com
 */
public class ConnectionManagerFactoryUnitTest extends BaseTest {
    private static final String TEST_STRING = "test0123456789";
    private static final Logger logger = Logger.getLogger(ConnectionManagerFactoryUnitTest.class);
	
	protected void setUp() throws Exception {
        MockContextFactory.setAsInitial();
    }
	
	
	public void testFactory() {
		Context ctx = null;
		com.arjuna.common.util.propertyservice.PropertyManager pm = ModulePropertyManager.getPropertyManager(ModulePropertyManager.DBSTORE_MODULE);
		pm.setProperty(Environment.MSG_STORE_DB_DATASOURCE_NAME, "blah");
		
        // Grab the connection created and do a simple Query - we expect a result
    	try {
    		ctx = new InitialContext();
    		MockDataSource mds = new MockDataSource(this);
    		String dataSourcename = Configuration.getStoreDBDatasourceName();
    		ctx.rebind(dataSourcename, mds);

    	} catch (NamingException e) {
			logger.debug("", e);
    		fail(e.getMessage());
    	} catch (Exception e) {
			logger.debug("", e);
    		fail(e.getMessage());		
    	}
		
		try {
			ConnectionManager cmf = ConnectionManagerFactory.getConnectionManager();
			if (cmf == null) {
				fail ("ConnectionManager returned should not be null.");
			}
		} catch (ConnectionManagerException e) {
			logger.debug("", e);
			fail(e.getMessage());
		}		
	}
	
	
	public void testExceptions() {
		Context ctx = null;
		com.arjuna.common.util.propertyservice.PropertyManager pm = ModulePropertyManager.getPropertyManager(ModulePropertyManager.DBSTORE_MODULE);
		pm.setProperty(Environment.MSG_STORE_DB_DATASOURCE_NAME, TEST_STRING);
		pm.setProperty(Environment.MSG_STORE_DB_CONN_MANAGER, TEST_STRING);
   
		// Grab the connection created and do a simple Query - we expect a result
    	try {
    		ctx = new InitialContext();
    		MockDataSource mds = new MockDataSource(this);
    		String dataSourcename = Configuration.getStoreDBDatasourceName();
    		ctx.rebind(dataSourcename, mds);
    		
    	} catch (NamingException e) {
			logger.debug("", e);
    		fail(e.getMessage());
    	} catch (Exception e) {
			logger.debug("", e);
    		fail(e.getMessage());		
    	}
		
		try {
			@SuppressWarnings("unused")
			ConnectionManager cmf = ConnectionManagerFactory.getConnectionManager();
			fail("Fake ConnectionManager class name should have thrown an exception");
		} catch (ConnectionManagerException e) {
		}		
	}
}
