/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.notification;

import static org.junit.Assert.assertTrue;

import java.net.URISyntaxException;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import junit.framework.JUnit4TestAdapter;

import org.jboss.internal.soa.esb.rosetta.pooling.ConnectionException;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.NamingContextException;
import org.jboss.soa.esb.listeners.gateway.DefaultESBPropertiesSetter;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.testutils.SerializableMockQueue;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockejb.jms.MockQueue;
import org.mockejb.jms.TextMessageImpl;
import org.mockejb.jndi.MockContextFactory;

/**
 * Integration test for {@link NotifyJMS}
 * <p/>
 * @author <a href="daniel.bevenius@redpill.se">Daniel Bevenius</a>				
 *
 */
public class NotifyJMSIntegrationTest
{
	private InitialContext context;
	private String destName = "/queue/A";
	private MockQueue queue;

	@Test
	public void setJMSReplyToQueue() throws JMSException, URISyntaxException, ConfigurationException, NamingException, ConnectionException, NamingContextException, NotificationException
	{
		TextMessageImpl inBoundJmsMessage = new TextMessageImpl();
		inBoundJmsMessage.setJMSReplyTo( queue );

		Message esbMessage = MessageFactory.getInstance().getMessage();
		new DefaultESBPropertiesSetter().setPropertiesFromJMSMessage( inBoundJmsMessage, esbMessage );
    		
		NotifyJMS notifyJMS = new NotifyQueues( new ConfigTree("test" ) );
		
		TextMessageImpl outBoundJmsMessage = new TextMessageImpl();
		notifyJMS.setJMSReplyTo( outBoundJmsMessage, esbMessage );
		
		Destination replyTo = outBoundJmsMessage.getJMSReplyTo();
		assertTrue( replyTo instanceof Queue );
	}
	
	@Before
	public void before() throws NamingException
	{
		MockContextFactory.setAsInitial();
		context = new InitialContext();
		MockContextFactory.setDelegateContext( context );
		queue = new SerializableMockQueue( destName );
		context.rebind( destName, queue );
	}
	
	@After
	public void after()
	{
		MockContextFactory.revertSetAsInitial();
	}
	
	/*
	 * Just here to help Ant to find annotated test.
	 */
	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter( NotifyJMSIntegrationTest.class );
	}	
	
}
