/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006
 */
package org.jboss.soa.esb.message.util;

import java.net.URI;
import java.net.URISyntaxException;

import org.jboss.soa.esb.addressing.eprs.HTTPEpr;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.message.format.MessageType;

import junit.framework.TestCase;

/**
 * @author <a href="mailto:tcunning@redhat.com">tcunning@redhat.com</a>
 */
public class TypeUnitTest extends TestCase {
	private static final String TEST_STRING = "test";
	
	public void testType() {
	
		Message msg1 = MessageFactory.getInstance().getMessage(MessageType.JAVA_SERIALIZED);
		
		msg1.getBody().add("foo", "bar");
		try {
			msg1.getHeader().getCall().setTo(new HTTPEpr("http://foo.bar"));
			msg1.getHeader().getCall().setMessageID(new URI("urn:1234"));
		} catch (URISyntaxException e1) {
			e1.printStackTrace();
			fail(e1.getMessage());
		}
		
		// Test with no fault
		boolean test = Type.isFaultMessage(msg1);
		assertEquals(false, test);
		
		// Set fault and test
		try {
			msg1.getFault().setCode(new URI("foo"));
			msg1.getFault().setReason(TEST_STRING);
			test = Type.isFaultMessage(msg1);
			assertEquals(true, test);
		} catch (URISyntaxException e) {
			e.printStackTrace();
			fail(e.getMessage());
		}
	}
}
