/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.message.format.tests;

import java.io.Serializable;

import junit.framework.TestCase;

import org.jboss.internal.soa.esb.message.format.xml.marshal.MarshalUnmarshalPlugin;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.util.Util;

/**
 * Unit tests for the MarshalUnmarshal class.
 * 
 * @author Mark Little
 */

public class MarshalUnmarshalUnitTest extends TestCase
{
    
    public void testMarshalUnmarshal () throws Exception
    {
        ModulePropertyManager.getPropertyManager(ModulePropertyManager.CORE_MODULE).setProperty(MarshalUnmarshalPlugin.MARSHAL_UNMARSHAL_PLUGIN+"1", ExampleMarshalUnmarshalPlugin.class.getName());
        Message msg = MessageFactory.getInstance().getMessage();
        SampleObject s = new SampleObject();
        
        s.val = 2001;
        
        msg.getBody().add(s);
        
        Serializable content = Util.serialize(msg);
        
        Message unmarshal = Util.deserialize(content);
        
        SampleObject s2 = (SampleObject) unmarshal.getBody().get();
        
        assertEquals(s.val, s2.val);
    }
    
    public void testMarshalUnmarshalError () throws Exception
    {
        try
        {
            Message msg = MessageFactory.getInstance().getMessage();
            ErrorObject s = new ErrorObject();
            
            s.val = 2001;
            
            msg.getBody().add(s);
            
            Util.serialize(msg);
            
            fail();
        }
        catch (Exception ex)
        {
        }
    }
}
