/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * (C) 2005-2008, JBoss Inc.
 */
package org.jboss.soa.esb.message.fault;

import junit.framework.TestCase;
import org.jboss.soa.esb.common.Environment;
import org.jboss.soa.esb.mock.MockAction;
import org.jboss.soa.esb.testutils.AbstractTestRunner;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.util.Type;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.addressing.eprs.LogicalEPR;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.listeners.message.errors.Factory;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class JBESB_2227_UnitTest extends TestCase {


    protected void setUp() throws Exception {
        System.setProperty(Environment.DEFAULT_INVM_SCOPE, "GLOBAL");
        MockAction.exception = null;
    }

    protected void tearDown() throws Exception {
        System.setProperty(Environment.DEFAULT_INVM_SCOPE, "NONE");
        MockAction.exception = null;
    }

    public void test_async() throws Exception {
        AbstractTestRunner testRunner = new AbstractTestRunner() {
            public void test() throws Exception {
                ServiceInvoker invoker = new ServiceInvoker("ServiceCat", "CallService");
                Message message = MessageFactory.getInstance().getMessage();
                ActionProcessingException exception = new ActionProcessingException("Exception!!!");

                message.getHeader().getCall().setFrom(new LogicalEPR("A", "B"));
                Message faultMessage = Factory.createErrorMessage(Factory.UNEXPECTED_ERROR, message, exception);

                // Should not get a MessageDeliverException...
                invoker.deliverAsync(faultMessage);

                // Mock action should have received faultMessage...
                waitForMockSet(faultMessage);
                assertTrue("Message equality", checkMessageEquality(faultMessage, MockAction.message));
            }
        }.setServiceConfig("JBESB-2227-config-01.xml");

        testRunner.run();
    }


    private void waitForMockSet(Message message) {
        long start = System.currentTimeMillis();

        while(System.currentTimeMillis() - start < 5000) {
            if(checkMessageEquality(message, MockAction.message)) {
                return;
            }
            sleep(50);
        }
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        } catch (InterruptedException e) {
            fail("Unexpected InterruptedException exception.");
        }
    }

    private static boolean checkMessageEquality(final Message expected, final Message actual) {
        return (actual != null) && (expected.getAttachment().equals(actual.getAttachment())) &&
            (expected.getBody().equals(actual.getBody())) &&
            (expected.getFault().equals(actual.getFault())) &&
            (expected.getProperties().equals(actual.getProperties())) &&
            (expected.getType().equals(actual.getType())) ;
    }
}
