/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.listeners.gateway;

import java.io.File;
import java.io.FileFilter;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.util.Util;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.ListenerTagNames;
import org.jboss.soa.esb.listeners.gateway.FileGatewayListener.FileFilterInit;

public class OverrideFileEndsWith implements FileFilter, FileFilterInit
{
    public OverrideFileEndsWith ()
    {
    }
    
    public void init (ConfigTree config) throws ConfigurationException
    {
        m_sSuffix = config.getRequiredAttribute(ListenerTagNames.FILE_INPUT_SFX_TAG).trim();;
        
        if (Util.isNullString(m_sSuffix))
            throw new ConfigurationException("Must specify file extension");
    }
    
    public boolean accept (File p_f)
    {
        return (p_f.isFile()) ? p_f.toString().endsWith(m_sSuffix) : false;
    }
    
    private String m_sSuffix;
}
