/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.listeners.gateway;

import junit.framework.TestCase;

import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.MockCourier;
import org.jboss.internal.soa.esb.couriers.MockCourierFactory;
import org.jboss.internal.soa.esb.services.registry.MockRegistry;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.ActionUtils;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.listeners.message.BasicMessageComposer;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.listeners.message.UncomposedMessageDeliveryAdapter;

/**
 * Tests for the Groovy Gateway.
 *
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class GroovyGatewayUnitTest extends TestCase {
	
	private Logger log = Logger.getLogger( GroovyGatewayUnitTest.class );

    private MockCourier courier1;

    protected void setUp() throws Exception {
        MockCourierFactory.install();
        MockRegistry.install();
        courier1 = new MockCourier(true);
        MockRegistry.register("x", "y", courier1);
    }

    protected void tearDown() throws Exception {
        MockRegistry.uninstall();
        MockCourierFactory.uninstall();
    }

    public void test() throws ConfigurationException, InterruptedException, ManagedLifecycleException {
        ConfigTree config = new ConfigTree("<config/>");
        final MockGroovyGateway groovyGateway;

        config.setAttribute("script", "/org/jboss/soa/esb/listeners/gateway/testgateway.groovy");
        groovyGateway = new MockGroovyGateway(config);

        groovyGateway.initialise();
        try
        {
            Thread thread = new Thread(new Runnable() {
                public void run() {
                    groovyGateway.doRun();
                }
            });
            thread.start();
    
            Thread.sleep(2000);
            assertTrue("Is already stopped", (courier1.message == null));
            groovyGateway.stopped = true;
            Thread.sleep(2000);
            assertTrue("Is not stopped", (courier1.message != null));
            assertEquals("Hi there!", (String) courier1.message.getBody().get());
        }
        finally
        {
            groovyGateway.destroy() ;
        }
    }

    // TODO: Fix build such that it can pick up the scripts from the src folder.
    public void x_test_prebundled() throws ConfigurationException {
        ConfigTree config = new ConfigTree("<config/>");
        @SuppressWarnings("unused")
        GroovyGateway groovyGateway;

        config.setAttribute("script", "MessageInjectionConsole");
        groovyGateway = new GroovyGateway(config);

        config.setAttribute("script", "MessageInjectionConsole.groovy");
        groovyGateway = new GroovyGateway(config);
    }

    private class MockGroovyGateway extends GroovyGateway {
        private boolean stopped = false;

        protected MockGroovyGateway(ConfigTree config) throws ConfigurationException {
            super(config);
        }

        protected UncomposedMessageDeliveryAdapter createDeliveryAdapter() throws ConfigurationException {
            try {
                BasicMessageComposer composer = new BasicMessageComposer();
                composer.setConfiguration(getConfig());
                return new UncomposedMessageDeliveryAdapter("x", "y", composer);
            } catch (MessageDeliverException e) {
                fail(e.getMessage());
            }
            return null;
        }

        public boolean waitUntilStopped(final long terminationPeriod) {
            try {
                Thread.sleep(terminationPeriod);
            } catch (InterruptedException e) {
            	log.error(e);
            }
            return stopped;
        }
    }
}
