/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006,
 * @author JBoss Inc.
 */

package org.jboss.soa.esb.listeners.config;

import junit.framework.TestCase;
import org.jboss.soa.esb.listeners.config.mappers.XMLBeansModel;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.JmsProviderType;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.Listener;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.JbossesbDocument.Factory;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.JmsBusDocument.JmsBus;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.JmsListenerDocument.JmsListener;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.JmsMessageFilterDocument.JmsMessageFilter;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.ServiceDocument.Service;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;

/**
 * Model specific unit tests extracted from GeneratorUnitTest.
 * 
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class Generator101ModelUnitTest extends TestCase {

	public void test_model() throws Exception {
		final InputStream is = getClass().getResourceAsStream("jbossesb_config_01.xml");
		final Reader reader = new InputStreamReader(is) ;
		XMLBeansModel model = new XMLBeansModel(Factory.parse(reader).getJbossesb());

		JmsBus bus = (JmsBus)model.getBus("server1-jms");
		JmsProviderType provider = (JmsProviderType) model.getProvider(bus);
		assertEquals("server1-jms", bus.getBusid());
		assertEquals("com.xyz.provider.XYZConnectionFactory", provider.getConnectionFactory());
		assertEquals("com.xyz.provider.NamingContextFactory", provider.getJndiContextFactory());
		assertEquals("xyz://server1:9876", provider.getJndiURL());
		assertEquals("com.xyz", provider.getJndiPkgPrefix());
		JmsMessageFilter busDestination = bus.getJmsMessageFilter();
		assertEquals("queue/A", busDestination.getDestName());
		assertEquals(JmsMessageFilter.DestType.QUEUE, busDestination.getDestType());
		assertEquals("service='Reconciliation'", busDestination.getSelector());

		List<Listener> gateways = model.getGatewayListeners();
		assertEquals(2, gateways.size());
		JmsListener gatewayListener = (JmsListener)gateways.get(0);
		assertEquals("Bank-JMS-Gateway", gatewayListener.getName());
		assertEquals("server1-jms", gatewayListener.getBusidref());
		assertTrue(gatewayListener.getIsGateway());
		assertEquals(1, gatewayListener.getMaxThreads());

		List<Listener> awareListeners = model.getESBAwareListeners();
		assertEquals(4, awareListeners.size());
		JmsListener awareListener = (JmsListener)awareListeners.get(0);
		assertEquals("Bank-Listener", awareListener.getName());
		assertEquals("local-jms", awareListener.getBusidref());
		assertTrue(!awareListener.getIsGateway());
		assertEquals(2, awareListener.getMaxThreads());
		JmsMessageFilter listenerDestination = awareListener.getJmsMessageFilter();
		assertEquals("queue/B", listenerDestination.getDestName());
		assertEquals(JmsMessageFilter.DestType.TOPIC, listenerDestination.getDestType());
		assertEquals("service='Reconciliation'", listenerDestination.getSelector());

		Listener untypedAwareListener = awareListeners.get(1);
		assertEquals("Bank-Listener-Generic", untypedAwareListener.getName());
		assertEquals("my-generic-bus", untypedAwareListener.getBusidref());
		assertTrue(!untypedAwareListener.getIsGateway());

		Service gatewayService = model.getService(gatewayListener);
		Service awareService = model.getService(awareListener);
		assertSame(gatewayService, awareService);
		assertEquals("Bank", awareService.getCategory());
		assertEquals("Reconciliation", awareService.getName());
		assertEquals("Bank Reconciliation Service", awareService.getDescription());
	}
}
