/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.listeners;

import java.io.File;
import java.io.FileInputStream;

import junit.framework.TestCase;

import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.parameters.ParamRepositoryFactory;

public class LifecycleUtilUnitTest extends TestCase
{
	public void testLifecycleUtil () throws Exception
	{
                final File tmpDir = new File(System.getProperty("java.io.tmpdir"));
                final String tmpDirURL = tmpDir.toURL().toExternalForm() ;
                
		boolean exception = false;
		
		try
		{
			LifecycleUtil.getListeners("fubar");
		}
		catch (IllegalArgumentException ex)
		{
			exception = true;
		}
		
		if (!exception)
			fail();
		
		try
		{
			String configFile = getClass().getResource("listenerFile.xml").getFile();
			FileInputStream input = new FileInputStream(configFile);
			byte[] data = new byte[input.available()];
			
			input.read(data);

			ParamRepositoryFactory.getInstance().add("test", new String(data));
                        
                        final ConfigTree tree = LifecycleUtil.getConfigTree("test") ;
                        final ConfigTree actionConfig = tree.getFirstChild("DummyActionConfig") ;
                        final ConfigTree epr = actionConfig.getFirstChild("EPR") ;
                        epr.setAttribute("URL", tmpDirURL) ;
			
			LifecycleUtil.getListeners(tree);
		}
		catch (IllegalArgumentException ex)
		{
			fail();
		}
		
		ConfigTree test = new ConfigTree("test");
		
		test.setAttribute(ListenerTagNames.GATEWAY_CLASS_TAG, "org.jboss.soa.esb.listeners.gateway.FileGatewayListener");
	
		LifecycleUtil.getGateways(test);
		LifecycleUtil.getGateways("test");
	}
	
}
