/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.http;

import static org.junit.Assert.*;

import junit.framework.JUnit4TestAdapter;

import org.junit.Test;

/**
 * Unit test for {@link HttpContentTypeUtil}.
 * <p/>
 * 
 * @author <a href="mailto:kevin.conner@jboss.com">Kevin Conner</a>
 */
public class HttpContentTypeUtilUnitTest
{
    @Test
    public void testTextMatches()
        throws Exception
    {
        // Should match text/*, application/xml and application/*+xml
        testTextMatch("text/html") ;
        testTextMatch("text/plain") ;
        testTextMatch("text/xml") ;
        
        testTextMatch("application/xml") ;
        
        testTextMatch("application/soap+xml") ;
        testTextMatch("application/atomcat+xml") ;
        testTextMatch("application/wsdl+xml") ;
    }

    @Test
    public void testBinaryMatches()
        throws Exception
    {
        // Should not match audio/*, example/*, image/*, message/*, model/*, multipart/*, video/* and application/* not in text matches
        testBinaryMatch("audio/3gpp") ;
        testBinaryMatch("audio/basic") ;
        testBinaryMatch("audio/mpeg") ;

        testBinaryMatch("example/dummy") ;

        testBinaryMatch("image/jpeg") ;
        testBinaryMatch("image/png") ;
        testBinaryMatch("image/tiff") ;

        testBinaryMatch("message/example") ;
        testBinaryMatch("message/global") ;
        testBinaryMatch("message/partial") ;

        testBinaryMatch("model/example") ;
        testBinaryMatch("model/mesh") ;
        testBinaryMatch("model/vrml") ;

        testBinaryMatch("multipart/alternative") ;
        testBinaryMatch("multipart/digest") ;
        testBinaryMatch("multipart/encrypted") ;

        testBinaryMatch("video/3gpp") ;
        testBinaryMatch("video/ogg") ;
        testBinaryMatch("video/raw") ;

        testBinaryMatch("application/json") ;
        testBinaryMatch("application/mp4") ;
        testBinaryMatch("application/pdf") ;
    }

    private void testTextMatch(final String type)
    {
        expectTextMimetype(type) ;
        expectTextMimetype(type + "; param1=1") ;
        expectTextMimetype(type + "; param1=1; param2=2") ;
    }

    private void expectTextMimetype(final String type)
    {
        assertTrue(type, HttpContentTypeUtil.isTextMimetype(type)) ;
    }

    private void testBinaryMatch(final String type)
    {
        expectBinaryMimetype(type) ;
        expectBinaryMimetype(type + "; param1=1") ;
        expectBinaryMimetype(type + "; param1=1; param2=2") ;
    }

    private void expectBinaryMimetype(final String type)
    {
        assertFalse(type, HttpContentTypeUtil.isTextMimetype(type)) ;
    }

    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(HttpContentTypeUtilUnitTest.class);
    }
}
