/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.common.tests.propertymanager;

import junit.framework.ComparisonFailure;
import junit.framework.TestCase;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.common.Environment;

import com.arjuna.common.internal.util.propertyservice.plugins.io.XMLFilePlugin;
import com.arjuna.common.util.propertyservice.PropertyManager;
import com.arjuna.common.util.propertyservice.PropertyManagerFactory;

public class PropertyManagerUnitTest extends TestCase
{
	
	private Logger log = Logger.getLogger( PropertyManagerUnitTest.class );

	public void testPropertyManager ()
	{
		System.setProperty("com.arjuna.common.util.propertyservice.verbosePropertyManager", "ON");
		
		PropertyManager corepm = PropertyManagerFactory.getPropertyManager("test.core", "core");
		
		try
        {
            corepm.load(XMLFilePlugin.class.getName(), "jbossesb-test-properties.xml");
        }
        catch (Exception e)
        {
        	log.error(e);
        	
            fail(e.toString());
        }
        
		assertEquals(corepm.getProperty(Environment.JNDI_SERVER_CONTEXT_FACTORY), "foobar");		
		assertEquals(corepm.getProperty(Environment.OBJECT_STORE_CONFIG_FILE), "file:config.xml");
		
		try
		{
			assertEquals(corepm.getProperty(Environment.SMTP_HOST), "thishost");
			
			fail();
		}
		catch (ComparisonFailure ex)
		{
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
		
		PropertyManager transportpm = PropertyManagerFactory.getPropertyManager("test.transports", "transports");
		
		try
        {
            transportpm.load(XMLFilePlugin.class.getName(), "jbossesb-test-properties.xml");
        }
        catch (Exception e)
        {
        	log.error(e);
        	
            fail(e.toString());
        }
        
        assertEquals(transportpm.getProperty(Environment.JNDI_SERVER_CONTEXT_FACTORY), "foobar");
        assertEquals(transportpm.getProperty(Environment.SMTP_HOST), "thishost");
	}

}
