/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.addressing.helpers.tests;

import junit.framework.TestCase;

import org.jboss.soa.esb.addressing.eprs.JDBCEpr;

/**
 * Unit tests for the EPR class.
 * 
 * @author Mark Little
 */

public class JDBCUnitTest extends TestCase
{

	public void testConstructor ()
	{
		try
		{
			new JDBCEpr("jdbc:arjuna:oracle:thin", "CREATE TABLE foo");
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
	
	public void testSetGet ()
	{
		try
		{
			JDBCEpr em = new JDBCEpr("jdbc:arjuna:oracle:thin", "CREATE TABLE foo");
			
			assertEquals(em.getURL(), "jdbc:arjuna:oracle:thin");
			assertEquals(em.getSQL(), "CREATE TABLE foo");
			
			em.setURL("jdbc:arjuna:oracle:thin");
			assertEquals(em.getURL(), "jdbc:arjuna:oracle:thin");
			
			em.setUserName("me");
			assertEquals(em.getUserName(), "me");
			
			em.setPassword("foobar");
			assertEquals(em.getPassword(), "foobar");
			
			try
			{
				em.setSQL("INVALID");
				
				fail();
			}
			catch (IllegalStateException ex)
			{
			}
			catch (Exception ex)
			{
				fail(ex.toString());
			}
			
			em.setDriver("cloudscape");
			assertEquals(em.getDriver(), "cloudscape");
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}

}
