package org.jboss.soa.esb.actions.templating;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.HashMap;

import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.addressing.eprs.HTTPEpr;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.message.format.MessageType;
import org.xml.sax.SAXException;

import junit.framework.TestCase;

public class StringTemplateProcessorUnitTest extends TestCase {
	
    private InputStream getStream(String sName) {
    	InputStream oRet =getClass().getResourceAsStream(sName);
    	if (null==oRet)
    		try { oRet = new FileInputStream(sName); }
    		catch(IOException e) { /* OK  Just fall through */}
    	return oRet;
    }
	
	public void testProcessor() {
		ConfigTree confTree = null;
		try {
			confTree = ConfigTree.fromInputStream(getStream("testfile1.xml"));
		} catch (SAXException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		StringTemplateProcessor stp = new StringTemplateProcessor(confTree);
		
		Message msg1 = MessageFactory.getInstance().getMessage(MessageType.JAVA_SERIALIZED);

        Map beans = new HashMap();
        Map orderItem = new HashMap();
        beans.put("orderItem", orderItem);
        orderItem.put("position", orderItem);
        orderItem.put("quantity", orderItem);
        orderItem.put("productId", orderItem);
        orderItem.put("title", orderItem);
        orderItem.put("price", orderItem);

        //msg1.getBody().add(beans);
        msg1.getBody().add("foo", "bar");
		try {
			msg1.getHeader().getCall().setTo(new HTTPEpr("http://foo.bar"));
			msg1.getHeader().getCall().setMessageID(new URI("urn:1234"));
			Message msg = stp.process(msg1); 
			if (msg == null) {
				fail("Message returned is null");
			}
			
		} catch (URISyntaxException e1) {
			e1.printStackTrace();
			fail(e1.getMessage());
		} catch (ActionProcessingException e) {
			e.printStackTrace();
			fail(e.getMessage());
		}
	}
}
