package org.jboss.soa.esb;

import java.io.ByteArrayOutputStream;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import junit.framework.TestCase;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public abstract class W3CDomUtils {
	private static Logger log = Logger.getLogger( W3CDomUtils.class );

	public static String serialize(Document document) {
		DOMSource src = new DOMSource(document);

		ByteArrayOutputStream byteBuf = new ByteArrayOutputStream(5000);
		StreamResult res = new StreamResult(byteBuf);

		try {
			Transformer transformer = TransformerFactory.newInstance().newTransformer();
			transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");
			transformer.transform(src, res);
		} catch (Exception e) {
			log.error(e);
			TestCase.fail("Failed to serialise doc.  See above stack trace.");
		}
		
		return byteBuf.toString();
	}
}
