/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.util.embedded.ftp;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

import org.apache.ftpserver.ConfigurableFtpServerContext;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.config.PropertiesConfiguration;
import org.apache.ftpserver.ftplet.Configuration;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.util.embedded.EmbeddableException;
import org.jboss.internal.soa.esb.util.embedded.EmbeddedServer;

/**
 * Class that can be used to test ftp functionality.
 * 
 * @author Daniel Bevenius
 *
 */
public class EmbeddedFtpServer implements EmbeddedServer
{
	private static Logger log = Logger.getLogger(EmbeddedFtpServer.class);
	
	private Properties ftpProperties;
	
	private FtpServer server;
	
	public EmbeddedFtpServer()
	{
	}

	/**
	 * 
	 * @param configFile	path to the ftpserver properties file used
	 * 						to configure the ftpserver.
	 */
	public EmbeddedFtpServer( String configFile)
	{
		if (configFile == null)
			throw new IllegalArgumentException("configFile must not be null");
		
		try
		{
			ftpProperties = getConfiguration( configFile ) ;
		} 
		catch (IOException e)
		{
			log.error( e );
			throw new IllegalStateException ( "Could not configure the ftp server");
		}
	}
	
	public EmbeddedFtpServer( Properties ftpProperties )
	{
		this.ftpProperties = ftpProperties;
	}
	
	
	public void addProperties( Properties ftpProperties)
	{
		if ( this.ftpProperties == null )
			this.ftpProperties = ftpProperties;
		else
			this.ftpProperties.putAll( ftpProperties );
	}
	
	public void start() throws EmbeddableException 
	{
		try 
		{
			Configuration configuration = new PropertiesConfiguration( ftpProperties );
			FtpServerContext context = new ConfigurableFtpServerContext( configuration );
			server = new FtpServer( context );
			server.start();
		} 
		catch (IOException e) 
		{
			log.error( e );
			throw new EmbeddableException( e );
		} 
		catch (Exception e) 
		{
			log.error( e );
			throw new EmbeddableException( e );
		}
	}
	
	public void stop() throws EmbeddableException  
	{ 
		server.stop();
	}
	
	private static Properties getConfiguration( String configFile ) throws IOException
	{
		FileInputStream in = null;
		try 
		{
			in = new FileInputStream( configFile );
			Properties props = new Properties();
			props.load( in );
			return props;
		} 
		finally
		{
			if ( in != null )
				in.close();
		}
	}

}
