/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */

package org.jboss.internal.soa.esb.services.registry;

import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.common.Environment;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.ServiceNotFoundException;

/**
 * MockRegistry Unit Test.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class MockRegistryUnitTest extends TestCase {

	public void test_install_uninstall() throws RegistryException {
		assertNotSame(MockRegistry.class.getName(), MockRegistry.regPropManager.getProperty(Environment.REGISTRY_IMPEMENTATION_CLASS));
		
		MockRegistry.install();
		assertEquals(MockRegistry.class.getName(), MockRegistry.regPropManager.getProperty(Environment.REGISTRY_IMPEMENTATION_CLASS));
		
		MockRegistry.uninstall();
		assertNotSame(MockRegistry.class.getName(), MockRegistry.regPropManager.getProperty(Environment.REGISTRY_IMPEMENTATION_CLASS));
	}

	public void test_features() throws RegistryException, ServiceNotFoundException {
		MockRegistry registry = new MockRegistry();
		EPR epr = new EPR();
		List<String> services = new ArrayList<String>();
		List<EPR> eprs = new ArrayList<EPR>();
		
		registry.registerEPR("cat1", "cat1-service1", "service-desc", epr, "epr-desc"); 
		registry.registerEPR("cat1", "cat1-service2", "service-desc", epr, "epr-desc"); 
		registry.registerEPR("cat1", "cat1-service3", "service-desc", epr, "epr-desc"); 
		registry.registerEPR("cat2", "cat2-service1", "service-desc", epr, "epr-desc"); 
		registry.registerEPR("cat2", "cat2-service2", "service-desc", epr, "epr-desc"); 
		registry.registerEPR("cat2", "cat2-service3", "service-desc", epr, "epr-desc"); 

		services.addAll(registry.findAllServices());
		assertEquals(6, services.size());
		assertEquals("cat1-service1", services.get(0));
		assertEquals("cat2-service1", services.get(3));
		assertEquals("cat2-service3", services.get(5));

		services.clear();
		services.addAll(registry.findServices("cat1"));
		assertEquals(3, services.size());
		assertEquals("cat1-service1", services.get(0));
		assertEquals("cat1-service2", services.get(1));
		assertEquals("cat1-service3", services.get(2));

		assertEquals(epr, registry.findEPR("cat1", "cat1-service1"));

		try {
			registry.unRegisterService("cat2", "cat1-service2");
			fail("Expected RegistryException for unknown service.");
		} catch(ServiceNotFoundException e) {
			//OK
		}
		
		eprs.addAll(registry.findEPRs("cat1", "cat1-service1"));
		assertEquals(1, eprs.size());
		assertEquals(epr, eprs.get(0));

		registry.unRegisterService("cat1", "cat1-service2");
		services.clear();
		services.addAll(registry.findAllServices());
		assertEquals(5, services.size());
		assertEquals("cat1-service1", services.get(0));
		assertEquals("cat1-service3", services.get(1));
		assertEquals("cat2-service1", services.get(2));

		registry.unRegisterEPR("cat2", "cat2-service2", epr);
		services.clear();
		services.addAll(registry.findAllServices());
		assertEquals(4, services.size());
		assertEquals("cat1-service1", services.get(0));
		assertEquals("cat1-service3", services.get(1));
		assertEquals("cat2-service1", services.get(2));
	}
}
