/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.internal.soa.esb.services.registry;

import junit.framework.TestCase;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.eprs.InVMEpr;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.ServiceNotFoundException;

import java.net.URI;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class InVMRegistryInterceptorUnitTest extends TestCase {

    public void test() throws ServiceNotFoundException, RegistryException {
        InVMRegistryInterceptor reg = new InVMRegistryInterceptor();
        reg.setRegistry(new MockRegistry()) ;

        try {
            reg.findEPR("x", "y");
            fail("Expected ServiceNotFoundException") ;
        } catch (final ServiceNotFoundException snfe) {
        }

        reg.registerEPR("x", "y", "blah", new InVMEpr(new EPR(URI.create("x://123"))), "blah");
        assertEquals(1, reg.findEPRs("x", "y").size());
        assertEquals("x://123", reg.findEPR("x", "y").getAddr().getAddress());

        reg.registerEPR("x", "y", "blah", new InVMEpr(new EPR(URI.create("x://123"))), "blah");
        assertEquals(2, reg.findEPRs("x", "y").size());

        reg.registerEPR("a", "z", "blah", new InVMEpr(new EPR(URI.create("x://12345"))), "blah");
        assertEquals(2, reg.findEPRs("x", "y").size());
        assertEquals(1, reg.findEPRs("a", "z").size());

        assertEquals(2, reg.findAllServices().size());
        assertEquals(1, reg.findServices("x").size());

        // unreg using a valid service + registred EPR... make sure EPR is removed...
        reg.unRegisterEPR("a", "z", new InVMEpr(new EPR(URI.create("x://12345"))));
        assertEquals(0, reg.findEPRs("a", "z").size());

        // unreg all for the service
        assertEquals(2, reg.findEPRs("x", "y").size());
        reg.unRegisterService("x", "y");
        assertEquals(0, reg.findEPRs("x", "y").size());
    }
}
