/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.message.urigen;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;

import junit.framework.TestCase;

import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.message.urigen.DefaultMessageURIGenerator;
import org.jboss.soa.esb.addressing.eprs.HTTPEpr;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.message.format.MessageType;
import org.jboss.soa.esb.message.urigen.URIGenerationException;

/**
 * Test the URIGeneration of DefaultMessageURIGenerator.
 * 
 * @author <a href="mailto:tcunning@redhat.com">tcunning@redhat.com</a>
 */
public class DefaultMessageURIGeneratorUnitTest extends TestCase {

    private static Logger logger = Logger.getLogger(JcrMessageURIGeneratorUnitTest.class);
    private static int MAX_COUNT = 10;
	private static String URI_PREFIX = "urn:jboss/esb/message/UID#"; 
    
	
    /**
     * Test that we're using the right prefix.
     */
    public void testPrefix() {
		DefaultMessageURIGenerator dmurig = new DefaultMessageURIGenerator();
		Message msg1 = MessageFactory.getInstance().getMessage(MessageType.JAVA_SERIALIZED);
			
		msg1.getBody().add("bar");
		try {
			msg1.getHeader().getCall().setTo(new HTTPEpr("http://foo.bar"));
			msg1.getHeader().getCall().setMessageID(new URI("urn:1234"));
		} catch (URISyntaxException e1) {
			fail(e1.getMessage());
		}
		
		try {
			URI uuid = dmurig.generateMessageURI(msg1);
			assertTrue("Make sure that URI starts with " + URI_PREFIX,
					uuid.toString().startsWith(URI_PREFIX));
		} catch (URIGenerationException e) {
			fail(e.getMessage());
		}
    }
    
	/**
	 * A simple test to make sure that the UUIDs created are somewhat unique -
	 * test to make sure we don't have duplicates in the first ten created.
	 */
	public void testUniqueness() {
		Hashtable<URI, String> hash = new Hashtable<URI, String>();
		DefaultMessageURIGenerator dmurig = new DefaultMessageURIGenerator();
		Message msg1 = MessageFactory.getInstance().getMessage(MessageType.JAVA_SERIALIZED);
			
		msg1.getBody().add("bar");
		try {
			msg1.getHeader().getCall().setTo(new HTTPEpr("http://foo.bar"));
			msg1.getHeader().getCall().setMessageID(new URI("urn:1234"));
		} catch (URISyntaxException e1) {
			fail(e1.getMessage());
		}
			
		for (int i = 0 ; i < MAX_COUNT; i++) {
				URI uuid = null;
				try {
					uuid = dmurig.generateMessageURI(msg1);
				} catch (URIGenerationException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				if (!hash.contains(uuid)) {
					hash.put(uuid, "1");
					logger.debug("EPR " + (i+1) + " is [" + uuid.toString() + "]");
				} else {
					fail("UUID was not unique within a set of " + MAX_COUNT);
				}
		}
	}
}

