/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.internal.soa.esb.message.format;

import junit.framework.TestCase;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageType;

import java.io.IOException;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class MessageSerializerUnitTest extends TestCase {

    public void test_xml() throws IOException {
        Message message = MessageFactoryImpl.getInstance().getMessage(MessageType.JBOSS_XML);
        testMessage(message);
    }

    public void test_java() throws IOException {
        Message message = MessageFactoryImpl.getInstance().getMessage(MessageType.JAVA_SERIALIZED);
        testMessage(message);
    }

    private void testMessage(Message originalMessage) throws IOException {
        originalMessage.getBody().add("This is an Message!");

        // Serialize...
        byte[] messageBytes = MessageSerializer.serialize(originalMessage);

        // Deserialize...
        Message deserializedMessage = MessageSerializer.deserialize(messageBytes);

        // Test...
        assertEquals("This is an Message!", deserializedMessage.getBody().get());
    }
}
