package org.jboss.internal.soa.esb.couriers.transport;

import java.net.URI;

import org.jboss.soa.esb.addressing.eprs.InVMEpr;
import org.jboss.soa.esb.services.registry.ServiceNotFoundException;
import org.junit.Test;

import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;

/**
 * InVMTransport unit tests.
 * 
 * Most of the delivery functionality is covered by the InVM courier unit tests.
 * 
 * @author <a href="mailto:kevin.conner@jboss.com">Kevin Conner</a>
 */
public class InVMTransportUnitTest
{
    private static final String TEST_CATEGORY1 = "test category1" ;
    private static final String TEST_CATEGORY2 = "test category2" ;
    private static final String TEST_NAME1 = "service name 1" ;
    private static final String TEST_NAME2 = "service name 2" ;
    
    @Test
    public void testRegistration()
        throws Exception
    {
        final InVMTransport transport = new InVMTransport() ;
        final InVMEpr epr1 = new InVMEpr(URI.create(InVMEpr.INVM_PROTOCOL + "://" + InVMEpr.createEncodedServiceId(TEST_CATEGORY1, TEST_NAME1))) ;
        final InVMEpr epr2 = new InVMEpr(URI.create(InVMEpr.INVM_PROTOCOL + "://" + InVMEpr.createEncodedServiceId(TEST_CATEGORY2, TEST_NAME2))) ;
        final InVMEpr epr3 = new InVMEpr(URI.create(InVMEpr.INVM_PROTOCOL + "://" + InVMEpr.createEncodedServiceId(TEST_CATEGORY2, TEST_NAME2))) ;
        final InVMEpr epr4 = new InVMEpr(URI.create(InVMEpr.INVM_PROTOCOL + "://" + InVMEpr.createEncodedServiceId(TEST_CATEGORY2, TEST_NAME2))) ;
        
        Assert.assertEquals("All services count", 0, transport.findAllServices().size()) ;
        Assert.assertEquals("Category count", 0, transport.findServices(TEST_CATEGORY1).size()) ;
        Assert.assertEquals("Category count", 0, transport.findServices(TEST_CATEGORY2).size()) ;
        
        transport.registerEPR(TEST_CATEGORY1, TEST_NAME1, epr1) ;
        
        Assert.assertEquals("All services count", 1, transport.findAllServices().size()) ;
        Assert.assertEquals("Category count", 1, transport.findServices(TEST_CATEGORY1).size()) ;
        Assert.assertEquals("Category count", 0, transport.findServices(TEST_CATEGORY2).size()) ;
        
        transport.registerEPR(TEST_CATEGORY2, TEST_NAME2, epr2) ;
        
        Assert.assertEquals("All services count", 2, transport.findAllServices().size()) ;
        Assert.assertEquals("Category count", 1, transport.findServices(TEST_CATEGORY1).size()) ;
        Assert.assertEquals("Category count", 1, transport.findServices(TEST_CATEGORY2).size()) ;
        
        transport.unRegisterEPR(TEST_CATEGORY1, TEST_NAME1, epr1) ;
        
        Assert.assertEquals("All services count", 1, transport.findAllServices().size()) ;
        Assert.assertEquals("Category count", 0, transport.findServices(TEST_CATEGORY1).size()) ;
        Assert.assertEquals("Category count", 1, transport.findServices(TEST_CATEGORY2).size()) ;
        
        transport.registerEPR(TEST_CATEGORY2, TEST_NAME2, epr3) ;
        transport.registerEPR(TEST_CATEGORY2, TEST_NAME2, epr4) ;
        
        Assert.assertEquals("All services count", 1, transport.findAllServices().size()) ;
        Assert.assertEquals("Category count", 0, transport.findServices(TEST_CATEGORY1).size()) ;
        Assert.assertEquals("Category count", 1, transport.findServices(TEST_CATEGORY2).size()) ;
        Assert.assertEquals("EPR count", 3, transport.findEPRs(TEST_CATEGORY2, TEST_NAME2).size()) ;
        
        transport.unRegisterEPR(TEST_CATEGORY2, TEST_NAME2, epr2) ;
        
        Assert.assertEquals("All services count", 1, transport.findAllServices().size()) ;
        Assert.assertEquals("Category count", 0, transport.findServices(TEST_CATEGORY1).size()) ;
        Assert.assertEquals("Category count", 1, transport.findServices(TEST_CATEGORY2).size()) ;
        Assert.assertEquals("EPR count", 2, transport.findEPRs(TEST_CATEGORY2, TEST_NAME2).size()) ;
        
        transport.unRegisterService(TEST_CATEGORY2, TEST_NAME2) ;
        
        Assert.assertEquals("All services count", 0, transport.findAllServices().size()) ;
        Assert.assertEquals("Category count", 0, transport.findServices(TEST_CATEGORY1).size()) ;
        Assert.assertEquals("Category count", 0, transport.findServices(TEST_CATEGORY2).size()) ;
        Assert.assertEquals("EPR count", 0, transport.findEPRs(TEST_CATEGORY2, TEST_NAME2).size()) ;
    }
    
    @Test
    public void testMissingServices()
        throws Exception
    {
        final InVMTransport transport = new InVMTransport() ;
        final InVMEpr epr1 = new InVMEpr(URI.create(InVMEpr.INVM_PROTOCOL + "://" + InVMEpr.createEncodedServiceId(TEST_CATEGORY1, TEST_NAME1))) ;
        final InVMEpr epr2 = new InVMEpr(URI.create(InVMEpr.INVM_PROTOCOL + "://" + InVMEpr.createEncodedServiceId(TEST_CATEGORY1, TEST_NAME2))) ;
        
        try
        {
            transport.unRegisterEPR(TEST_CATEGORY1, TEST_NAME1, epr1) ;
            Assert.fail("Expected ServiceNotFoundException") ;
        }
        catch (final ServiceNotFoundException snfe) {} // expected
        
        transport.unRegisterService(TEST_CATEGORY1, TEST_NAME1) ;
        
        transport.registerEPR(TEST_CATEGORY1, TEST_NAME2, epr2) ;
        
        try
        {
            transport.unRegisterEPR(TEST_CATEGORY1, TEST_NAME1, epr1) ;
            Assert.fail("Expected ServiceNotFoundException") ;
        }
        catch (final ServiceNotFoundException snfe) {} // expected
        
        transport.unRegisterService(TEST_CATEGORY1, TEST_NAME1) ;
    }
    
    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(InVMTransportUnitTest.class);
    }
}
