/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public class ObjLocatorSorter
{
  private java.util.List<ObjLocator> m_olRows;
  private int m_iQcols;
  private char[] m_caSrt;

  public ObjLocatorSorter(ObjLocator[] p_oa)
  { m_iQcols  = (null==p_oa) ? 0
      : p_oa.length<1 ? 0
      : p_oa[0].getColumnCount();
    if (p_oa == null) {
      m_olRows = Collections.emptyList() ;
    } else {
      m_olRows = Arrays.asList(p_oa);
    }
  } //________________________________

  public ObjLocator[] sort (int p_iCol)
  { if (null == m_caSrt)
    { m_caSrt = new char[m_iQcols];
      for (int i1=0; i1<m_caSrt.length; i1++) m_caSrt[i1]='d';
    }
    ObjLocator [] oaLoc = new ObjLocator[m_olRows.size()];
    m_olRows.toArray(oaLoc);
    Arrays.sort(oaLoc,new RowCmp(p_iCol,ascOrDesc(oaLoc,p_iCol)));
    m_olRows  = Arrays.asList(oaLoc);
    return oaLoc;
  } //________________________________
  private static char ascOrDesc(ObjLocator[] p_oa, int p_iCol)
  {
    String sMin = "";
    for (int i1=0; i1<p_oa.length;i1++)
    { Object oCurr = p_oa[i1].get(p_iCol);
      if (! (oCurr instanceof String))    continue;
      if (sMin.compareToIgnoreCase((String)oCurr) > 0)
          return 'a';
      sMin  = (String) oCurr;
    }
    return 'd';
  } //________________________________

  // ---------------------------------------------------------
  //  Comparator for Table Columns
  // ---------------------------------------------------------
  private static class RowCmp implements Comparator<ObjLocator>
  {
    int m_iCol;
    boolean m_bAsc;

    RowCmp(int p_i, char p_c)
    {
      m_iCol = p_i;
      m_bAsc = 'a'==Character.toLowerCase(p_c);
    } //______________________________

    public int compare(ObjLocator o1, ObjLocator o2)
    {
      String s1 = (String) o1.get(m_iCol);
      String s2 = (String) o2.get(m_iCol);
      int iCmp = s1.compareToIgnoreCase(s2);
      return (m_bAsc) ? iCmp : -iCmp;
    } //______________________________
  } //_______________________________________________
} //______________________________________________________

