/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * (C) 2005-2008, JBoss Inc.
 */
package org.jboss.soa.esb.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;

import java.io.*;

import org.jboss.internal.soa.esb.assertion.AssertArgument;

/**
 * FreeMarker template.
 * <p/>
 * Coppied from Smooks Core.
 *
 * @author <a href="mailto:tom.fennelly@gmail.com">tom.fennelly@gmail.com</a>
*/
public class FreeMarkerTemplate {

    private String templateText;
    private Template template;

    public FreeMarkerTemplate(String templateText) {
        AssertArgument.isNotNullAndNotEmpty(templateText, "templateText");
        Reader templateReader = new StringReader(templateText);

        try {
            try {
                template = new Template("free-marker-template", templateReader, new Configuration());
            } finally {
                templateReader.close();
            }
        } catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException.", e);
        }
    }

    public FreeMarkerTemplate(String templatePath, Class basePath) {
        AssertArgument.isNotNullAndNotEmpty(templatePath, "templatePath");
        this.templateText = templatePath;

        try {
            Configuration configuration = new Configuration();

            if(basePath != null) {
                configuration.setClassForTemplateLoading(basePath, "");
            }
            template = configuration.getTemplate(templatePath);
        } catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException.", e);
        }
    }

    public String getTemplateText() {
        return templateText;
    }

    public String apply(Object contextObject) throws TemplateException {
        StringWriter outputWriter = new StringWriter();
        try {
            template.process(contextObject, outputWriter);
        } catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException.", e);
        }
        return outputWriter.toString();
    }
}