/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.parameters;


/**
 * Parameter Repository Definition.
 * <p/>
 * A ParamRepository implementation allows persistence, retrieval and removal of
 * parameter values.
 * <p/>
 * Note that it is assumed that implementations are Thread Safe.
 * 
 * @author <a href="mailto:schifest@gmail.com">Esteban Shifman</a>
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public interface ParamRepository {
	
	// byte[] versions of the add and get methods might be needed on this.
	// In fact, if this is done - rename the existing add and get methods
	// to addString and getString and add the new byte[] methods as add/get.
	
	/**
	 * Store a parameter value in the repository.
	 * @param name The parameter name.  Must not be <code>null</code>.
	 * @param value The parameter value.  Must not be <code>null</code>.
	 * @throws ParamRepositoryException Failed to store the specified parameter value.
	 */
	public void add(String name, String value) throws ParamRepositoryException;

	/**
	 * Get the value associated with the named parameter.
	 * @param name The parameter name.  Must not be <code>null</code>.
	 * @return The parameter value, or null if the parameter is not available in 
	 * the repository.
	 * @throws ParamRepositoryException  The parameter exists, but an error has occured
	 * while readingit. 
	 */
	public String get(String name) throws ParamRepositoryException;

	/**
	 * Remove a parameter, or a hierarchy of parameters.
	 * <p/>
	 * Because the repository is hierarchical in nature, parameters can be addressed
	 * explicitly or as a group using a hierarchical name.
	 * @param name The parameter name.  Must not be <code>null</code>.
	 * @throws ParamRepositoryException Failed to remove the parameter, or hierarchy of parameters,
	 * from the repository..
	 */
	public void remove(String name) throws ParamRepositoryException;
}
