/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.notification;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Map;

import org.jboss.internal.soa.esb.notification.MacroExpander;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.services.NotificationManager;

public class NotifyUtil
{

	public static void notifyOK (NotificationManager p_oNH,
			ConfigTree p_oParent, Serializable p_o, Map p_oCtx)
	{
		try
		{
			ConfigTree[] oaP = p_oParent.getChildren(NotificationList.ELEMENT);
			for (int i1 = 0; i1 < oaP.length; i1++)
			{
				NotificationList oCurr = new NotificationList(oaP[i1]);
				if (!oCurr.isOK()) continue;
				ConfigTree oCpy = oaP[i1].cloneObj();
				MacroExpander.replaceMacros(oCpy, p_oCtx);
				p_oNH.sendNotifications(oCpy, p_o);
			}
		}
		catch (Exception e)
		{
			e.printStackTrace(System.out);
		}
	} // __________________________________

	public static void notifyError (NotificationManager p_oNH,
			ConfigTree p_oParent, Object p_o, Map p_oCtx, Exception p_e)
	{
		ByteArrayOutputStream oBO = new ByteArrayOutputStream();
		PrintStream oPS = new PrintStream(oBO);
		try
		{
			oPS.println(p_o.toString());
			if (null != p_e)
			{
				p_e.printStackTrace(oPS);
			}
			oPS.close();

			String sMsg = oBO.toString();
			ConfigTree[] oaP = p_oParent.getChildren(NotificationList.ELEMENT);
			// if (oaP.length<1) // Uncomment this line to send only to the list

			// REVIEW: What's going on here? What's the difference between
			// sending an
			// error notification and sending a regular notification apart from
			// there being an
			// error message? What's the difference between how the
			// InotificationHandler
			// interface is used on the notifyOK and notifyError methods?

			p_oNH.sendNotifications(sMsg);
			for (int i1 = 0; i1 < oaP.length; i1++)
			{
				NotificationList oCurr = new NotificationList(oaP[i1]);
				if (!oCurr.isErr())
				{
					continue;
				}
				MacroExpander.replaceMacros(oaP[i1], p_oCtx);
				p_oNH.sendNotifications(oaP[i1], sMsg);
			}
		}
		catch (Exception e)
		{
			e.printStackTrace(System.out);
		}
	} // __________________________________
	
	/*
	 * Util method for generating an error message containing the
	 * stacktrace for the passed in Exception instance.
	 * 
	 * Note that there is no need to close a StringWriter instance.
	 */
	public static String createExceptionErrorString( final String msg, final Exception e )
	{
		final StringBuilder sb = new StringBuilder();
        sb.append("[").append(msg);
        sb.append(", Stacktrace : ");
        final StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        sb.append(sw.toString());
        sb.append("]");
        return sb.toString();
	}

} // ____________________________________________________________________________
