/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.notification;

import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.message.body.content.BytesBody;
import org.jboss.soa.esb.util.Util;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;

public class NotifyConsole extends NotificationTarget 
{
    private MessagePayloadProxy payloadProxy;

    public NotifyConsole(ConfigTree tree)
	{
		super(tree);
        payloadProxy = new MessagePayloadProxy(tree,
                                               new String[] {BytesBody.BYTES_LOCATION},
                                               new String[] {BytesBody.BYTES_LOCATION});
        payloadProxy.setNullGetPayloadHandling(MessagePayloadProxy.NullPayloadHandling.LOG);
    }
	
	@Override
	public void sendNotification(Message message) throws NotificationException 
	{
        try {
            Object obj = payloadProxy.getPayload(message);
            if(obj instanceof byte[]) {
                System.out.println("ConsoleNotifier "+Util.getStamp()+"<" + new String((byte[])obj) + ">");
            } else {
                System.out.println("ConsoleNotifier "+Util.getStamp()+"<" + obj + ">");
            }
        } catch (MessageDeliverException e) {
            throw new NotificationException(e);
        }
	}
	
}
