/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */

package org.jboss.soa.esb.listeners.message;

/**
 * MessageCounter is a MBean implementation which keeps track of message data and 
 * metadata.
 * 
 * @author <a href="mailto:tcunning@redhat.com">tcunning@redhat.com</a> 
 *
 */
public class MessageCounter implements MessageCounterMBean {

	/**
	 * Get the total number of failed messages.
	 * @return total number of failed messages
	 */
	public int getFailedMessageCount() {
		return MessageCounterStatistics.getMessageCounterStatistics().getFailedMessageCount();
	}

	/**
	 * Get the time the last message was processed at.
	 * @return time the last message was processed at
	 */
	public String getLastSuccessfulMessageDate() {
		return MessageCounterStatistics.getMessageCounterStatistics().getLastSuccessfulMessageDate();
	}
	
	/**
	 * Get the time the last message was processed at.
	 * @return time the last message was processed at
	 */
	public String getLastFailedMessageDate() {
		return MessageCounterStatistics.getMessageCounterStatistics().getLastFailedMessageDate();
	}
	
	/**
	 * Get the total number of processed messages, both successful and failed.
	 * @return total number of processed messages
	 */
	public int getTotalMessageCount() {
		return MessageCounterStatistics.getMessageCounterStatistics().getTotalMessageCount();
	}

	/**
	 * Get the total number of successfully processed messages.
	 * @return total number of successfully processed messages
	 */
	public int getSuccessfulMessageCount() {
		return MessageCounterStatistics.getMessageCounterStatistics().getSuccessfulMessageCount();
	}

	public long getProcessedBytes() {
		return MessageCounterStatistics.getMessageCounterStatistics().getProcessedBytes();
	}
	
	public long getFailedBytes() {
		return MessageCounterStatistics.getMessageCounterStatistics().getFailedBytes();
	}

	/**
	 * Get the average time to process a message.
	 * @return average time to process a message 
	 */
	public Double getAverageSuccessTime() {
		return MessageCounterStatistics.getMessageCounterStatistics().getAverageSuccessTime();
	}
	
	/**
	 * Reset the counts - this resets the totals and the last message time. 
	 */
	public void resetCounts() {
		MessageCounterStatistics.getMessageCounterStatistics().resetCounts();
	}
}
