/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.listeners.message;

import org.jboss.soa.esb.BaseException;

/**
 * If a user attempts to use a request-response MEP while within the
 * scope of a transaction then the request won't be sent until the transaction
 * commits, which can't happen if the sender thread is blocked. Rather than wait for
 * a timeout to occur we spot this incompatibility at send time and throw this
 * exception. The application can then take appropriate action.
 */

public class IncompatibleTransactionScopeException extends BaseException {

    private static final long serialVersionUID = 1L;

    public IncompatibleTransactionScopeException(String message) {
        super(message);
    }

    public IncompatibleTransactionScopeException(String message, Throwable cause) {
        super(message, cause);
    }
}
