/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.gateway.remotestrategies.cache;

import org.apache.log4j.Logger;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jgroups.View;

/**
 * This listener will upon node eviction events delete the 
 * node from the cache. 
 * <p> 
 * This listener should be used in combination with a cache loader <br>
 * so that it is possible to set an eviction policy and when nodes <br>
 * are evicted they are also deleted from the cache loaders store
 * </p>
 * 
 * @author <a href="daniel.bevenius@redpill.se">Daniel Bevenius</a>				
 *
 */
public class DeleteOnEvictTreeCacheListener implements TreeCacheListener
{
	private Logger log = Logger .getLogger( DeleteOnEvictTreeCacheListener.class );
	
	private TreeCache treeCache;
	
	public DeleteOnEvictTreeCacheListener( final TreeCache treeCache ) 
	{
		if ( treeCache == null )
			throw new IllegalArgumentException( "treeCache must not be null" );
		
		this.treeCache = treeCache;
	}


	/**
	 * Will remove from the passed in fqn upon being
	 * evicted from the cache.
	 */
	public void nodeEvicted( Fqn fqn ) 
	{
		try
		{
			treeCache.remove( fqn );
			log.debug( "removed fqn : " + fqn );
		} 
		catch (CacheException e)
		{
			log.error( "Exception while trying to remove data for fqn : " + fqn , e );
		}
	}
	
	public void cacheStarted(TreeCache arg0) {}
	public void cacheStopped(TreeCache arg0) {}
	public void nodeCreated(Fqn arg0) {}
	public void nodeLoaded(Fqn arg0) {}
	public void nodeModified(Fqn arg0) {}
	public void nodeRemoved(Fqn arg0) {}
	public void nodeVisited(Fqn arg0) {}
	public void viewChange(View arg0) {}
	
}
