/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * (C) 2005-2008, JBoss Inc.
 */
package org.jboss.soa.esb.listeners.gateway.mina;

import org.apache.mina.common.IoHandler;
import org.jboss.soa.esb.client.ServiceInvoker;

/**
 * A Message handler is responsible for recieving the MINA message and packaging
 * the message payload into a ESB Message object, and dispatching to the target
 * service in the ESB.
 *
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public interface MessageHandler extends IoHandler {

    /**
     * Set the {@link ServiceInoker} instance to be used
     * to dispatch messages to the ESB Service
     *
     * @param invoker The ServiceInvoker instance.
     */
    void setServiceInvoker(final ServiceInvoker invoker);
}
