/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.http;

import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.message.Message;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class HttpResponse implements Serializable {

    public static final String RESPONSE_KEY = HttpResponse.class.getName() + "#response";

    private Integer responseCode;
    private String contentType;
    private String encoding;
    private Long length;
    private List<HttpHeader> headers = new ArrayList<org.jboss.soa.esb.http.HttpHeader>();

    public HttpResponse(int responseCode) {
        this.responseCode = responseCode;
    }

    public Integer getResponseCode() {
        return responseCode;
    }

    public Long getLength() {
        return length;
    }

    public void setLength(Long length) {
        this.length = length;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getEncoding() {
        return encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public List<HttpHeader> getHttpHeaders() {
        return headers;
    }

    public void addHeader(HttpHeader header) {
        AssertArgument.isNotNull(header, "header");
        headers.add(header);
    }

    public static HttpResponse getResponse(Message message) {
        AssertArgument.isNotNull(message, "message");
        return (HttpResponse) message.getBody().get(HttpResponse.RESPONSE_KEY);
    }

    public void setResponse(Message message) {
        AssertArgument.isNotNull(message, "message");
        message.getBody().add(HttpResponse.RESPONSE_KEY, this);
    }
}
