/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.common;

/**
 * The exception raised to cover errors using transaction strategies.
 * 
 * @author <a href='mailto:kevin.conner@jboss.com'>Kevin Conner</a>
 */
public class TransactionStrategyException extends Exception
{
    /**
     * serial version UID of this exception.
     */
    private static final long serialVersionUID = 7547084336832099461L;

    /**
     * Construct a default transaction strategy exception.
     */
    public TransactionStrategyException()
    {
    }

    /**
     * Construct a transaction strategy exception with the specified message.
     * @param message The exception message.
     */
    public TransactionStrategyException(final String message) 
    {
        super(message);
    }

    /**
     * Construct a transaction strategy exception with the associated cause.
     * @param cause The associated cause.
     */
    public TransactionStrategyException(final Throwable cause)
    {
        super(cause);
    }

    /**
     * Construct a transaction strategy exception with the specified message and associated cause.
     * @param message The exception message.
     * @param cause The associated cause.
     */
    public TransactionStrategyException(String message, Throwable cause)
    {
        super(message, cause);
    }
}
 