package org.jboss.soa.esb.addressing.util;

import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.message.Message;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */

/**
 * Provide some helper routines for common requirements.
 */

public class DefaultFaultTo
{

    /**
     * Initialise the message as a reply to the specified call details.
     * @param message The reply message.
     * @param callDetails The call details used to generate the reply.
     * @return true if the message was initialised, false otherwise.
     */
	public static boolean initialiseReply(final Message message, final Call callDetails)
	{
		return initialiseReply(message, callDetails, false) ;
	}

    /**
     * Initialise the message as a reply to the specified call details.
     * @param message The reply message.
     * @param callDetails The call details used to generate the reply.
     * @param oneWay True if this is a one way invocation.
     * @return true if the message was initialised, false otherwise.
     */
    public static boolean initialiseReply(final Message message, final Call callDetails, final boolean oneWay)
    {
        return DefaultReplyTo.initialiseReply(message, callDetails, getFaultTo(callDetails, oneWay)) ;
    }
	
    /**
     * Get the appropriate faultTo address..
     * @param callDetails The call details used to generate the reply.
     * @return The faultTo address or null if none set.
     */
	static EPR getFaultTo(final Call callDetails, final boolean oneWay)
	{
		if (callDetails == null)
		{
			return null ;
		}
		
		final EPR faultTo = callDetails.getFaultTo() ;
		if (faultTo != null)
		{
			return faultTo ;
		}
		else if (!oneWay)
		{
			return DefaultReplyTo.getReplyTo(callDetails) ;
		}
		return null ;
	}
}